//
//  ViewController.m
//  sample
//
//  Created by savin on 13. 8. 7..
//  Copyright (c) 2013 savin. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.

    //Add 3
    [self printerInitialize];
}

- (void) viewDidUnload
{
    [_uiTextFieldStatus release];
    _uiTextFieldStatus = nil;
    [_uiTextFieldTrack3 release];
    _uiTextFieldTrack3 = nil;
    [_uiTextFieldTrack2 release];
    _uiTextFieldTrack2 = nil;
    [_uiTextFieldTrack1 release];
    _uiTextFieldTrack1 = nil;
    if( _pMyCustomTarget )
    {
        [_pMyCustomTarget release];
        _pMyCustomTarget = nil;
    }
    
    [super viewDidUnload];
}

- (void)didReceiveMemoryWarning
{
    NSLog(@"%s",__FUNCTION__);
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}




//Add 4
-(void) printerInitialize
{
    _pController                = [BXPrinterController getInstance];
    
    _pController.delegate       = self;
    _pController.lookupCount    = 5;
    _pController.AutoConnection = BXL_CONNECTIONMODE_NOAUTO;
    [_pController open];
    
    _uiLabelSDKVersion.text = _pController.version;
    _uiLabelReleaseDate.text = _pController.releaseDate;
}


#define _PRINTER_BUTTON_ACTIONS_
#import "ViewController_PtrButtonAction.m"
#undef _PRINTER_BUTTON_ACTIONS_


//Add 5
#define _PRINTER_DELEGATE_ACTIONS_
#import "PrinterDelegate.m"
#undef _PRINTER_DELEGATE_ACTIONS_


- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    if([textField  isFirstResponder])
        [textField resignFirstResponder];
    return YES;
}

- (IBAction) buttonUp_Lookup:(id)sender
{
    NSLog(@" Lookup / Targetting Button Up.");
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
        [_pController lookup];
    });
}
- (IBAction) buttonUp_Connect:(id)sender
{
    NSLog(@" Connect Button Up.");
    
    if( _pMyCustomTarget )
    {
        [_pMyCustomTarget release];
        _pMyCustomTarget = nil;
    }
    
    if( [_uiTextFieldAddress.text length] > 3)
    {
        _pMyCustomTarget = [BXPrinter new];
        
        if( [_uiTextFieldAddress.text hasPrefix:@"IP_"])
        {
            _pMyCustomTarget.address = [_uiTextFieldAddress.text substringFromIndex:3];
            _pMyCustomTarget.port = 9100;
            _pMyCustomTarget.connectionClass = BXL_CONNECTIONCLASS_WIFI;
        }
        else if( [_uiTextFieldAddress.text hasPrefix:@"SN_"]) {
            _pMyCustomTarget.serialNumber = [_uiTextFieldAddress.text substringFromIndex:3];
            _pMyCustomTarget.connectionClass = BXL_CONNECTIONCLASS_BT;
        }
        else
        {
            _pMyCustomTarget.macAddress = [_uiTextFieldAddress.text substringFromIndex:3];
            _pMyCustomTarget.connectionClass = BXL_CONNECTIONCLASS_BT;
        }
        _pController.target = _pMyCustomTarget;
        
        [_pController selectTarget];
    }
    
    //Add 9
    [_pController setTimeoutOnConnection:5.0];

    if( NO==[_pController connect] )
        NSLog(@"Connect Error");
}

- (IBAction)switch_EnableLSB:(UISwitch*)sender
{
    [_pController enableLSB:[sender isOn]];
}

- (void)dealloc
{
   [_uiLabelSDKVersion release];
   [_uiLabelReleaseDate release];
   
   [_uiMacAddress release];
   [_uiPrinterName release];
   [_uiFWVersion release];
   [_uiPaperStatus release];
   [_uiCoverStatus release];
   [_uiPowerStatus release];
   
    [_uiDirectIoInput release];
   
   [_uiTextFieldAddress release];
   [_uiButtonMSR release];
    [_uiTextFieldTrack1 release];
    [_uiTextFieldTrack2 release];
    [_uiTextFieldTrack3 release];
    [_uiTextFieldStatus release];
    [super dealloc];
}



- (IBAction)switch_TransactionMode:(UISwitch*)sender
{
    [_pController transactionMode:[sender isOn]];
}

- (IBAction)switch_AsyncMode:(UISwitch*)sender
{
    [_pController asyncMode:[sender isOn]];
}

- (IBAction) buttonUp_PrintPDF:(id)sender
{
        NSLog(@" PrintPDF Button Up.");
    
        //Add 13
        NSString *path = [[NSBundle mainBundle] pathForResource:@"Bixolon" ofType:@"pdf"];
        int nLevel = 10050;
    
        _pController.imageDitheringWithIgnoreWhite = YES;
        [_pController printPDF:path
                    pageNumber: 1
                         width:-1
                          level:nLevel];
}

- (IBAction) buttonUp_PrintImage:(id)sender {
    [_pController printBitmapWithImage:[UIImage imageNamed:@"Sample.png"] width:BXL_WIDTH_FULL level: 10050];
}



- (IBAction) buttonUp_GetStatus:(id)sender
{
    if(BXL_SUCCESS==[_pController checkPrinter:BXL_MASK_ALL])//BXL_MASK_MODELNAME])
    {
        _uiPrinterName.text = _pController.target.modelStr;
        _uiFWVersion.text = _pController.target.versionStr;
        _uiMacAddress.text  = _pController.target.macAddress;
        _uiCoverStatus.text = (_pController.state&BXL_STS_COVEROPEN)?@"OPENED": @"CLOSED";
        _uiPaperStatus.text = (_pController.state&BXL_STS_PAPEREMPTY)?@"EMPTY": @"FILL";
        _uiBluetoothDeviceName.text = _pController.target.bluetoothDeviceName;
        
//        switch(_pController.power)
//        {
//            case BXL_PWR_HIGH:
//                _uiPowerStatus.text = @"HIGH";
//                break;
//            case BXL_PWR_MIDDLE:
//                _uiPowerStatus.text = @"MIDDLE";
//                break;
//            case BXL_PWR_LOW:
//                _uiPowerStatus.text = @"LOW";
//                break;
//            case BXL_PWR_SMALL:
//                _uiPowerStatus.text = @"SMALL";
//                break;
//            case BXL_PWR_NOT:
//                _uiPowerStatus.text = @"NOT";
//                break;
//        }
        
        NSString* strPrintText = [NSString stringWithFormat:@" printer Name : %@\r\n FWVersion:%@\r\n MacAddress : %@\r\n CoverStatus : %@\r\n PaperStatus : %@\r\n PowerStatus : %@\r\n", _uiPrinterName.text, _uiFWVersion.text, _uiMacAddress.text, _uiCoverStatus.text, _uiPaperStatus.text, _uiPowerStatus.text];
        
        [_pController printText:strPrintText];
    }
}


@end
